implementation module StdFontDef


//	Version 1.0

//	Definition of fonts.


import StdInt, StdString


::	FontDef
	=	{	fName		:: !FontName
		,	fStyles		:: ![FontStyle]
		,	fSize		:: !FontSize
		}
::	FontMetrics
	=	{	fAscent		:: !Int
		,	fDescent	:: !Int
		,	fLeading	:: !Int
		,	fMaxWidth	:: !Int
		}
::	FontName			:==	String
::	FontStyle			:==	String
::	FontSize			:==	Int


//	Font constants:

SerifFontDef			:==	{fName="Times",			fStyles=[],fSize=10}
SansSerifFontDef		:==	{fName="Arial",			fStyles=[],fSize=10}
SmallFontDef			:==	{fName="Small Fonts",	fStyles=[],fSize=7 }
NonProportionalFontDef	:==	{fName="Courier",		fStyles=[],fSize=10}
SymbolFontDef			:==	{fName="Symbol",		fStyles=[],fSize=10}


//	Style constants:

ItalicsStyle			:== "Italic"
BoldStyle				:== "Bold"
UnderlinedStyle			:== "Underline"


//	Standard lineheight of a font, given its metrics:

fontLineHeight fMetrics	:==	fMetrics.fLeading + fMetrics.fAscent + fMetrics.fDescent
